<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MyusersController;
use App\Http\Controllers\PostsController;
use App\Http\Controllers\TournamentController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\VenueController;
use App\Http\Controllers\GameController;
use App\Http\Controllers\RoundsController;

header('Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE');
 header('Access-Control-Allow-Headers: *');
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware('auth:sanctum')->group(function(){
    Route::get('/user', function (Request $request) {
    return $request->user();

});

Route::post('/logout',[MyusersController::class,'logout']);
Route::get('/currentuser',[MyusersController::class,'current']);
Route::delete('/currentuser/delete/{id}',[MyusersController::class,'destroy']);
Route::post('/currentuser/update/{id}',[MyusersController::class,'update']);
Route::get('/userscount',[MyusersController::class,'userscount']);
Route::get('/allusers',[MyusersController::class,'allusers']);

// Route::post('/tournament/add',[TournamentController::class,'store']);
// Route::get('/tournament/show',[TournamentController::class,'show']);
// Route::put('/tournament/update/{id}',[TournamentController::class,'update']);
// Route::delete('/tournament/delete/{id}',[TournamentController::class,'destroy']);




// Route::post('/orders/add',[MyusersController::class,'storeOrders']);
// Route::get('/orders/get',[MyusersController::class,'showOrders']);
// Route::get('/order/last/get',[MyusersController::class,'showLastOrder']);
// Route::get('/orderscount/get',[MyusersController::class,'countOrders']);
// Route::post('/orders/edit/{id}',[MyusersController::class,'updateorders']);
// Route::delete('/orders/delete/{id}',[MyusersController::class,'destroyOrders']);

Route::post('/products/add',[MyusersController::class,'storeProducts']);
Route::get('/productscount/get',[MyusersController::class,'countProducts']);
Route::post('/products/edit/{id}',[MyusersController::class,'updateProducts']);
Route::delete('/products/delete/{id}',[MyusersController::class,'destroyProducts']);

// Route::post('/customers/add',[MyusersController::class,'storeCustomers']);
// Route::get('/customerscount/get',[MyusersController::class,'countCustomers']);
// Route::get('/customers/get',[MyusersController::class,'showCustomers']);
// Route::get('/customers/get/all',[MyusersController::class,'allCustomers']);
// Route::post('/customers/edit/{id}',[MyusersController::class,'updateCustomers']);
// Route::delete('/customers/delete/{id}',[MyusersController::class,'destroyCustomers']);

Route::post('/category/add',[MyusersController::class,'storeCategory']);
Route::get('/categorycount/get',[MyusersController::class,'countCategory']);
Route::get('/category/get',[MyusersController::class,'showCategory']);
Route::post('/category/edit/{id}',[MyusersController::class,'updateCategory']);
Route::delete('/category/delete/{id}',[MyusersController::class,'destroyCategory']);

});

Route::get('/products/get',[MyusersController::class,'showProducts']);
Route::get('/products/get/web',[MyusersController::class,'showProductsWeb']);
Route::get('/products/get/all',[MyusersController::class,'showProductsAll']);
Route::get('/category/get/all',[MyusersController::class,'showCategoriesAll']);

Route::post('/register',[MyusersController::class,'store']);



Route::post('/sendMail',[MyusersController::class,'sendMail']);
Route::post('/sendMail2',[MyusersController::class,'sendMail2']);

//Clear Cache facade value:
Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    return '<h1>Cache facade value cleared</h1>';
});

//Reoptimized class loader:
Route::get('/optimize', function() {
    $exitCode = Artisan::call('optimize');
    return '<h1>Reoptimized class loader</h1>';
});

//Route cache:
Route::get('/route-cache', function() {
    $exitCode = Artisan::call('route:cache');
    return '<h1>Routes cached</h1>';
});

//Clear Route cache:
Route::get('/route-clear', function() {
    $exitCode = Artisan::call('route:clear');
    return '<h1>Route cache cleared</h1>';
});

//Clear View cache:
Route::get('/view-clear', function() {
    $exitCode = Artisan::call('view:clear');
    return '<h1>View cache cleared</h1>';
});

//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

Route::post('/login',[MyusersController::class,'login']);


// Route::put('/posts/update/{id}',[PostsController::class,'updatepost']);
