import { createStore } from "vuex";
import axiosClient from "../axios.js";

const store = createStore({
state:{
    user:{
        data:sessionStorage.getItem("DATA"),
        token:sessionStorage.getItem("TOKEN")
    }
    
},

getters:{},
actions:{

 async register({commit }, user){
  return axiosClient.post('/register', user)
   .then(({data})=>{
    commit('setUser', data)
    return data;
   })
 },

 async login({commit }, user){
  return axiosClient.post('/login', user)
   .then(({data})=>{
    commit('setUser', data)
    return data;
   })
 },
 
 logout({commit }){
  return axiosClient.post('/logout')
   .then(response=>{
    commit('logout')
    window.location.replace('/')
  })
 },
 getUser({commit }){
  return axiosClient.get('/currentuser')
  .then(({data})=>{
    commit('setUser', data)
    return data;
   })
  
 }
,
  async posts({commit }, post){
  return axiosClient.post('/posts/add', post)
   .then(({data})=>{
    commit('Saveposts', data)
    return data;
   })
 }

},
mutations:{
    logout: (state)=>{
      state.user.data = {};
      state.user.token = null;
      sessionStorage.removeItem('TOKEN');
      sessionStorage.removeItem('DATA');
    },
    setUser:(state, userData)=>{
       state.user.token= userData.token;
       state.user.data= userData.user;
       sessionStorage.setItem('TOKEN', userData.token);
       sessionStorage.setItem('DATA', JSON.stringify(userData.user));
    },
      Saveposts:(state, post)=>{
      state.posts= [...state.posts, post.data];
    }
    
},
modules:{},

})

export default store;