import { createRouter, createWebHistory} from 'vue-router'
import Login from '../components/views/Login.vue'
import Register from '../components/views/Register.vue'
import LayOut from '../components/LayOut.vue'
import LayOut2 from '../components/LayOut2.vue'
import store from "@/store"

import Products from '../components/views/Products.vue'
import ProductsAdd from '../components/views/ProductsAdd.vue'
import Categories from '../components/views/Categories.vue'
import CategoriesAdd from '../components/views/CategoriesAdd.vue'
import Dashboard from '../components/views/Dashboard.vue'
import Users from '../components/views/Users.vue'
import Home from '../components/views/Home.vue'
import Cart from '../components/views/Cart.vue'

// End Admin
import { ref } from 'vue'

const red2 = ref('')
const myrole = ref('')

red2.value = JSON.parse(store.state.user.data)
if(red2.value !== null){
 myrole.value = red2.value.role

}
else{
    myrole.value == 'null'
}
const routes = [
   
 
    
    {
        path: '/home',
        meta:{requiresAuth:false},
        children:[
            {path:'/:data', name: 'Home2', component: Home},
            

        ]
    }
    ,
    
    {
        path: '/login',
        meta:{requiresAuth:false},
        children:[
            {path:'/login', name: 'Login', component: Login},
            // {path:'/register', name: 'Register', component: Register},

            
        ]
    },
    {
        path: '/',
        // component: LayOut2,
        meta:{requiresAuth:false},
        children:[
             // {path:'/', name: 'Home', component: Home},
             {path:'/', name: 'Home', component: Home},
             {path:'/cart', name: 'Cart', component: Cart},
            
        ]
    },
    
    {
        path: '/logged',
        component: LayOut,
        meta:{requiresAuth:true},
        children:[
            {path:'/items', name: 'Products', component: Products},
            {path:'/itemsAdd', name: 'ProductsAdd', component: ProductsAdd},
            {path:'/categories', name: 'Categories', component: Categories},
            {path:'/categoriesAdd', name: 'CategoriesAdd', component: CategoriesAdd},
            {path:'/dashboard', name: 'Dashboard', component: Dashboard},
            {path:'/users', name: 'Users', component: Users},
            {path:'/register', name: 'Register', component: Register},
        ]
    },




];

const router = createRouter({
    history: createWebHistory(),
    routes
})


router.beforeEach((to, from, next) => {
    if (to.meta.requiresAuth && !store.state.user.token){
        next({ name: 'Login' })
    }

    else if( myrole.value == 'user' && (to.name==='Account' || to.name==='Myposts' || to.name==='Premium' || to.name==='Settings' || to.name==='Profile' || to.name==='Booking')){
        next({name:'UserAccount'})
    }

    else if( myrole.value == 'admin' && (to.name==='UserAccount' )){
        next({name:'Account'})
    }

    // if the user is not authenticated
    else if( store.state.user.token && (to.name==='Login')){
        next({name:'Dashboard'})
    }
    else if( store.state.user.token && (to.name==='items')){
        next()
    }
    else if( store.state.user.token && (to.name==='Maelezo')){
        next()
    }
    else if( store.state.user.token && (to.name==='Users')){
        next()
    }
    else if( store.state.user.token && (to.name==='Dashboard')){
        next()
    }
    else if( store.state.user.token && (to.name==='Register')){
        next()
    }
    else if( store.state.user.token && (to.name==='Shamba')){
        next()
    }
    else next()
  })


export default router;