<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Products;
use App\Models\Categories;
use App\Models\Customers;
use App\Models\Orders;
use App\Models\Delivery;
use App\Mail\OdersMail;
use App\Mail\ContactMail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Mail;



class MyusersController extends Controller
{
    // 

        // emails-------------------

        public function sendMail(Request $request)
        {
            $this->validate($request,[
                'name'=>'required|max:200',
                
            ]);

      

          $details = [
              'name'=>$request->name,
              'phone'=>$request->phone,
              'message'=>$request->message,
              'email'=>$request->email,
          ];

          Mail::to('info@jamhuristationers.co.tz')->send(new OdersMail($details));


           return response()->json(['message' => 'Email sent successfully!'])
            ->header('Access-Control-Allow-Origin', '*')
            ->header('Access-Control-Allow-Methods', 'POST, GET, OPTIONS, DELETE, PUT')
            ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
        }


        public function sendMail2(Request $request)
        {
            $this->validate($request,[
                'name'=>'required|max:200',
                
            ]);

      

          $details = [
              'name'=>$request->name,
              'phone'=>$request->phone,
              'message'=>$request->message,
              'title'=>$request->title,
              'email'=>$request->email,
          ];

          Mail::to('info@jamhuristationers.co.tz')->send(new ContactMail($details));


           return response()->json(['message' => 'Email sent successfully!'])
            ->header('Access-Control-Allow-Origin', '*')
            ->header('Access-Control-Allow-Methods', 'POST, GET, OPTIONS, DELETE, PUT')
            ->header('Access-Control-Allow-Headers', 'Content-Type, Authorization');
        }


        // endEmails -------------
        
        public function store(Request $request){
            $data = $request->validate([
               'firstname'=>'required|string',
               'lastname'=>'required|string',
               'phone'=>'required|string',
               'email'=>'required|string|email|unique:users,email',
               'role'=>'required',
               'password'=>'required'
            ]);

            if($request->file('file')){
                $fileNameWithExt = $request->file('image')->getClientOriginalName();
                //File name
                $filename = pathinfo($fileNameWithExt, PATHINFO_FILENAME);

                $extension = $request->file('image')->getClientOriginalExtension();

                $fileNameToStore = $filename. '_' .time(). '.' .$extension;
                $path = $request->image->move(public_path('images'),$fileNameToStore);
                // $path = $request->file('image')->storeAs('public/images', $fileNameToStore); 

                $user = User::create([
                   'firstname'=> $data['firstname'],
                   'lastname'=> $data['lastname'],
                   'phone'=> $data['phone'],
                   'image'=>$fileNameToStore,
                   'email'=> $data['email'],
                   'role'=> $data['role'],
                   'password'=>Hash::make($data['password']),
                ]);

            }
            else{
                 $user = User::create([
                   'firstname'=> $data['firstname'],
                   'lastname'=> $data['lastname'],
                   'phone'=> $data['phone'],
                   'email'=> $data['email'],
                   'role'=> $data['role'],
                   'password'=>Hash::make($data['password']),
                ]);

            }


            $details = [
              'firstname'=>$request->firstname,
              'lastname'=>$request->lastname,
              'role'=>$request->role,
             
            ];
            

            $token = $user->createToken('main')->plainTextToken;

            //  Mail::to($data['email'])->send(new OdersMail($details));
           

            return response([
                 'user'=>$user,
                 'token'=>$token
            ]); 
        }

        public function update(Request $request, $id){
            $data2 = $request->validate([
               'role'=>'required',
            ]);

            if($request->file('file')){
                $fileNameWithExt = $request->file('image')->getClientOriginalName();
                //File name
                $filename = pathinfo($fileNameWithExt, PATHINFO_FILENAME);

                $extension = $request->file('image')->getClientOriginalExtension();

                $fileNameToStore = $filename. '_' .time(). '.' .$extension;
                $path = $request->image->move(public_path('images'),$fileNameToStore);
                // $path = $request->file('image')->storeAs('public/images', $fileNameToStore); 

                $newpost= User::find($id)->update([
                'firstname' => $request->firstname,
                'lastname' => $request->lastname,
                'phone' => $request->phone,
                'image'=>$fileNameToStore,
                'email' => $request->email ,
                'role' =>  $request->role,
                'phone' =>  $request->phone,

                ]);
            }
            else{
                $newpost= User::find($id)->update([
                'firstname' => $request->firstname,
                'lastname' => $request->lastname,
                'phone' => $request->phone,
                'email' => $request->email ,
                'role' =>  $request->role,
                'phone' =>  $request->phone,

                ]);
            }


              $result = $newpost;

             return response([
             'user'=>$newpost, 
             'success'=>$result
             
             ]); 
             
        }
        

      public function login(Request $request){
       
       $request->validate([
         'email'=>['required','email'],
         'password'=>['required']
       ]);

       if(Auth::attempt($request->only('email', 'password'))){
        $user=Auth::user();
       $token = $user->createToken('main')->plainTextToken;

         return response([
             'user'=>$user,
             'token'=>$token,
        ]); 
       }
       throw ValidationException::withMessages([
         'email'=>['The provided credentials are incorrect']
       ]);

      

    }

    public function logout(){
      
    $user=Auth::user();
    $user->currentAccessToken()->delete();

         return response([
         'success'=>true
    ]); 

    }

    public function current(){
       $user= Auth::user();
        return response([
        'user'=>$user
        ]);
    }

    public function userscount(){
       $userscount= User::where('role','like','admin') -> count();
        return response([
        'userscount'=>$userscount
        ]);
    }



    public function allusers(){

        if($allusers= User::where('role','like','admin') ->orderByDesc('created_at')->paginate(8)){
            return response([
            'allusers'=>$allusers
            ]); 
        }

        else {
            return response([
            'allusers'=>'error'
            ]); 
        }
    }

    public function destroy($id)
    {

      $User = User::find($id);

      if(empty($User)){
        $success= false;
        $response=['message'=>'User could not be deleted'];
      }
      else{
        $success= $User->delete();
        $response=['message'=>'User deleted'];
      }

      return ['success'=>$success, 'response'=>$response];
    }


    // Customers ------------------------------------------------------

     public function storeCustomers(Request $request)
    {
        
        // dd($request->all());
         $this->validate($request,[
            'name'=>'required',
            'address'=>'required',
            'phone'=>'required',
            'lat'=>'required',
            'lng'=>'required',
            
        ]);


        $Customers = new Customers;
        $Customers->name = $request->name;
        $Customers->address = $request->address;
        $Customers->phone = $request->phone;
        $Customers->lat = $request->lat;
        $Customers->lng = $request->lng;
        // if( $request->total!=="undefined"){
        //  $Customers->total = $request->total;    
        // }     
       
        

        
        
        // $path = $request->file('eventsimg')->storeAs('public/images', $fileNameToStore);



        if($Customers ->save()){

        return response([
        'customer'=>$Customers,
        'success'=>true
        ]);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }


    }



    /**
     * Display the specified resource.
     */
    public function showCustomers(Customers $Customers)
    {

        if($mael=Customers::orderByDesc('id')->paginate(8)){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function allCustomers(Customers $Customers)
    {

        if($mael=Customers::orderByDesc('id')->get()){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function countCustomers(){
       $mcount= Customers::get()->count();
        return response([
        'customers'=>$mcount
        ]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function updateCustomers(Request $request)
    {
        $id= $request->id;
       
        $data = $request->all();
        $prod=Customers::find($id);
        // dd($data);
        foreach($data as $key => $value ){
        $prod->{$key}=$value;
        }
        $result = $prod->save();

        return response([
        'Customers'=>$result

        ]); 
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroyCustomers(Customers $Customers,$id)
    {
        //

      $Customers = Customers::find($id);

      if(empty($Customers)){
        $success= false;
        $response=['message'=>'Failed'];
      }
      else{
        $success= $Customers->delete();
        $response=['message'=>'Success'];
      }

      return ['success'=>$success, 'response'=>$response];
    }



    
// Categories ------------------------------------------------------

     public function storeCategory(Request $request)
    {
        
        
        // dd($request->all());
        $this->validate($request,[
          'name'=>'required',
         
          
        ]);

        $Categories = new Categories;
        $Categories->name = $request->name;
       
        if($Categories ->save()){

        return response([
        'Categories'=>$Categories,
        'success'=>true
        ]);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }


    }



    /**
     * Display the specified resource.
     */
  

    public function showCategoriesAll(Categories $Categories)
    {

        if($cat=Categories::orderByDesc('created_at')->paginate(8)){
         // $cat ='cat';
        return response($cat);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function countCategory(){
       $mcount= Categories::get()->count();
        return response([
        'categories'=>$mcount
        ]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function updateCategory(Request $request)
    {
            $cid= $request->id;
       
                $newpost= Categories::find($cid)->update([
                'name' => $request->name,

                ]);
            
            // $path = $request->file('image')->storeAs('public/images', $fileNameToStore);

              $result = $newpost;

             return response([
             'Categories'=>$newpost, 
             'success'=>$result
             
             ]); 
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroyCategory(Categories $Categories,$id)
    {
        //

      $Categories = Categories::find($id);

      if(empty($Categories)){
        $success= false;
        $response=['message'=>'Failed'];
      }
      else{
        $success= $Categories->delete();
        $response=['message'=>'Success'];
      }

      return ['success'=>$success, 'response'=>$response];
    }

    // Delivery ------------------------------------------------------

     public function storeProducts(Request $request)
    {
        
        
        // dd($request->all());
        $this->validate($request,[
            'name'=>'required',
            'cat'=>'required',
            'desc'=>'required',
            'image'=> 'mimes:jpeg,jpg,svg,webp,png,gif|required|max:1000',
            
        ]);

        $fileNameWithExt = $request->file('image')->getClientOriginalName();
        //File name
        $filename = pathinfo($fileNameWithExt, PATHINFO_FILENAME);
        $extension = $request->file('image')->getClientOriginalExtension();
        $fileNameToStore = $filename. '_' .time(). '.' .$extension;
        $path = $request->image->move(public_path('images'),$fileNameToStore);
        // $path = $request->file('image')->storeAs('public/images', $fileNameToStore); 


        $Products = new Products;
        $Products->name = $request->name;
        $Products->cat = $request->cat;
        $Products->desc = $request->desc;
        $Products->img = $fileNameToStore;

        // if( $request->total!=="undefined"){
        //  $Products->total = $request->total;    
        // }     
       

        // $path = $request->file('eventsimg')->storeAs('public/images', $fileNameToStore);



        if($Products ->save()){

        return response([
        'products'=>$Products,
        'success'=>true
        ]);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }


    }



    /**
     * Display the specified resource.
     */
    public function showProducts(Products $Products)
    {

        if($mael=Products::orderByDesc('id')->paginate(8)){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function showProductsAll(Products $Products)
    {

        if($mael=Products::orderByDesc('id')->get()){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function showProductsWeb(Products $Products)
    {

        if($mael=Products::orderByDesc('id')->paginate(9)){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function countProducts(){
       $mcount= Products::get()->count();
        return response([
        'products'=>$mcount
        ]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function updateProducts(Request $request)
    {
        $id= $request->id;
       
    

        if($request->file('image')){
           $fileNameWithExt = $request->file('image')->getClientOriginalName();
           //File name
           $filename = pathinfo($fileNameWithExt, PATHINFO_FILENAME);
           $extension = $request->file('image')->getClientOriginalExtension();
           $fileNameToStore = $filename. '_' .time(). '.' .$extension;
           $path = $request->image->move(public_path('images'),$fileNameToStore);
           // $path = $request->file('image')->storeAs('public/images', $fileNameToStore); 

           $newpost= Products::find($id)->update([
           'name' => $request->name,
           'cat' => $request->cat,
           'desc' => $request->desc,
           'img'=>$fileNameToStore,

          ]);
       }
       else{
           $newpost= Products::find($id)->update([
           'name' => $request->name,
           'cat' => $request->cat,
           'desc' => $request->desc,
           
           ]);
       }


         $result = $newpost;

        return response([
        'products'=>$newpost, 
        'success'=>$result
        
        ]); 
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroyProducts(Products $Products,$id)
    {
        //

      $Products = Products::find($id);

      if(empty($Products)){
        $success= false;
        $response=['message'=>'Failed'];
      }
      else{
        $success= $Products->delete();
        $response=['message'=>'Success'];
      }

      return ['success'=>$success, 'response'=>$response];
    }





    // Orders ------------------------------------------------------

     public function storeOrders(Request $request)
    {
        
        
        // dd($request->all());
        $this->validate($request,[
            'orderno'=>'required',
            'creator'=>'required',
            'creatorName'=>'required',
            'Pname'=>'required',
            'Pphone'=>'required',
            'Ptime'=>'required',
            'Paddress'=>'required',
            'Dname'=>'required',
            'Dphone'=>'required',
            'Daddress'=>'required',
            'price'=>'required',
            'total'=>'required',
            'paymentMethod'=>'required',
            'distance'=>'required',
                
        ]);


        $Orders = new Orders;
        $Orders->orderno = $request->orderno;
        $Orders->creator = $request->creator;
        $Orders->creatorName = $request->creatorName;
        $Orders->Pname = $request->Pname;
        $Orders->Pphone = $request->Pphone;
        $Orders->Ptime = $request->Ptime;
        $Orders->Paddress = $request->Paddress;
        $Orders->Dphone = $request->Dphone;
        $Orders->Dname = $request->Dname;
        $Orders->Dtime = $request->Dtime;
        $Orders->Daddress = $request->Daddress;
        $Orders->price = $request->price;
        $Orders->dispatchFee = $request->dispatchFee;
        $Orders->total = $request->total;
        $Orders->instruction = $request->instruction;
        $Orders->paymentMethod = $request->paymentMethod;
        $Orders->distance = $request->distance;

        // if( $request->total!=="undefined"){
        //  $Orders->total = $request->total;    
        // }     
       

        // $path = $request->file('eventsimg')->storeAs('public/images', $fileNameToStore);



        if($Orders ->save()){

        return response([
        'Orders'=>$Orders,
        'success'=>true
        ]);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }


    }



    /**
     * Display the specified resource.
     */
    public function showOrders(Orders $Orders)
    {

        if($mael=Orders::orderByDesc('id')->paginate(8)){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

     public function showLastOrder(Orders $Orders)
    {

        if($mael=Orders::where('creator', auth()->id())->latest()->first()){
         // $mael ='mael';
        return response($mael);
        }
        else{
        return response([   
        'error'=>true
        ]);
        }

    }

    public function countOrders(){
       $mcount= Orders::get()->count();
        return response([
        'Orders'=>$mcount
        ]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function updateOrders(Request $request)
    {
        $id= $request->id;
       
        $data = $request->all();
        $prod=Orders::find($id);
        // dd($data);
        foreach($data as $key => $value ){
        $prod->{$key}=$value;
        }
        $result = $prod->save();

        return response([
        'Orders'=>$result

        ]); 
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroyOrders(Orders $Orders,$id)
    {
        //

      $Orders = Orders::find($id);

      if(empty($Orders)){
        $success= false;
        $response=['message'=>'Failed'];
      }
      else{
        $success= $Orders->delete();
        $response=['message'=>'Success'];
      }

      return ['success'=>$success, 'response'=>$response];
    }



    }


